/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.component.CurrentItemStackComponent;
import me.jddev0.ep.component.EPDataComponentTypes;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.item.ActivatableItem;
import me.jddev0.ep.item.WorkingItem;
import me.jddev0.ep.item.energy.EnergizedPowerEnergyItem;
import me.jddev0.ep.util.EnergyUtils;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class InventoryCoalEngineItem
extends EnergizedPowerEnergyItem
implements ActivatableItem,
WorkingItem {
    public static final long CAPACITY = ModConfigs.COMMON_INVENTORY_COAL_ENGINE_CAPACITY.getValue();
    public static final long MAX_EXTRACT = ModConfigs.COMMON_INVENTORY_COAL_ENGINE_TRANSFER_RATE.getValue();
    public static final double ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.COMMON_INVENTORY_COAL_ENGINE_ENERGY_PRODUCTION_MULTIPLIER.getValue();

    public InventoryCoalEngineItem(class_1792.class_1793 props) {
        super(props, CAPACITY, 0L, MAX_EXTRACT);
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        boolean active = this.isActive(stack);
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.inventory_coal_engine.status").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)("tooltip.energizedpower.inventory_coal_engine.status." + (active ? "activated" : "deactivated"))).method_27692(active ? class_124.field_1060 : class_124.field_1061)));
        if (class_437.method_25442()) {
            long energyProductionLeft = this.getEnergyProductionLeft(stack);
            class_1799 item = this.getCurrentBurningItem(stack);
            if (energyProductionLeft > 0L && item != null) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.inventory_coal_engine.txt.shift.currently_burning").method_27692(class_124.field_1080).method_10852(item.method_7964()));
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.inventory_coal_engine.txt.shift.energy_production_left", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(energyProductionLeft)}).method_27692(class_124.field_1080));
            }
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.inventory_coal_engine.txt.shift.1").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.inventory_coal_engine.txt.shift.2").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.shift_details.txt").method_27692(class_124.field_1054));
        }
    }

    private void distributeEnergy(class_1799 itemStack, class_1937 level, class_1661 inventory, int slot, boolean selected) {
        ArrayList<EnergyStorage> consumerItems = new ArrayList<EnergyStorage>();
        ArrayList<Long> consumerEnergyValues = new ArrayList<Long>();
        long consumptionSum = 0L;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            EnergyStorage energyStorage;
            class_1799 testItemStack;
            if (i == slot || !EnergyStorageUtil.isEnergyStorage((class_1799)(testItemStack = inventory.method_5438(i))) || (energyStorage = (EnergyStorage)EnergyStorage.ITEM.find(testItemStack, (Object)ContainerItemContext.ofPlayerSlot((class_1657)inventory.field_7546, (SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)inventory, null).getSlots().get(i))))) == null || !energyStorage.supportsInsertion()) continue;
            try (Transaction transaction = Transaction.openOuter();){
                long received = energyStorage.insert(Math.min(MAX_EXTRACT, this.getEnergy(itemStack)), (TransactionContext)transaction);
                if (received <= 0L) continue;
                consumptionSum += received;
                consumerItems.add(energyStorage);
                consumerEnergyValues.add(received);
                continue;
            }
        }
        ArrayList<Long> consumerEnergyDistributed = new ArrayList<Long>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0L);
        }
        long consumptionLeft = Math.min(MAX_EXTRACT, Math.min(this.getEnergy(itemStack), consumptionSum));
        this.setEnergy(itemStack, this.getEnergy(itemStack) - consumptionLeft);
        int divisor = consumerItems.size();
        block13: while (consumptionLeft > 0L) {
            long consumptionPerConsumer = consumptionLeft / (long)divisor;
            if (consumptionPerConsumer == 0L) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / (long)divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                long consumptionDistributed = (Long)consumerEnergyDistributed.get(i);
                long consumptionOfConsumerLeft = (Long)consumerEnergyValues.get(i) - consumptionDistributed;
                long consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0L) break block13;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            long energy = (Long)consumerEnergyDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)consumerItems.get(i)).insert(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void method_7888(class_1799 itemStack, class_1937 level, class_1297 entity, int slot, boolean selected) {
        super.method_7888(itemStack, level, entity, slot, selected);
        if (level.method_8608()) {
            return;
        }
        if (!(entity instanceof class_1657)) return;
        class_1657 player = (class_1657)entity;
        if (!this.isActive(itemStack)) {
            return;
        }
        class_1661 inventory = player.method_31548();
        this.distributeEnergy(itemStack, level, inventory, slot, selected);
        long energyProductionLeft = this.getEnergyProductionLeft(itemStack);
        if (energyProductionLeft > 0L) {
            int progress = this.getProgress(itemStack);
            int maxProgress = this.getMaxProgress(itemStack);
            class_1799 currentBurningItem = this.getCurrentBurningItem(itemStack);
            if (progress >= 0 && maxProgress > 0 && progress < maxProgress && currentBurningItem != null) {
                long energyProductionPerTick = energyProductionLeft / (long)(maxProgress - progress);
                if (this.getEnergyCapacity(itemStack) - this.getEnergy(itemStack) < energyProductionPerTick) {
                    if (!this.isWorking(itemStack)) return;
                    itemStack.method_57379(EPDataComponentTypes.WORKING, (Object)false);
                    return;
                }
                if (!this.isWorking(itemStack)) {
                    itemStack.method_57379(EPDataComponentTypes.WORKING, (Object)true);
                }
                this.setEnergy(itemStack, this.getEnergy(itemStack) + energyProductionPerTick);
                itemStack.method_57379(EPDataComponentTypes.ENERGY_PRODUCTION_LEFT, (Object)(energyProductionLeft - energyProductionPerTick));
                if (++progress != maxProgress) {
                    itemStack.method_57379(EPDataComponentTypes.PROGRESS, (Object)progress);
                    return;
                }
                this.resetProgress(itemStack);
            } else {
                this.resetProgress(itemStack);
            }
        }
        int i = 9;
        while (i < inventory.field_7547.size()) {
            if (i != slot) {
                long energyProduction;
                class_1799 testItemStack = inventory.method_5438(i);
                Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)testItemStack.method_7909());
                long l = energyProduction = burnTime == null ? -1L : (long)burnTime.intValue();
                if (energyProduction > 0L) {
                    energyProduction = (long)((double)energyProduction * ENERGY_PRODUCTION_MULTIPLIER);
                    itemStack.method_57379(EPDataComponentTypes.ENERGY_PRODUCTION_LEFT, (Object)energyProduction);
                    itemStack.method_57379(EPDataComponentTypes.CURRENT_ITEM, (Object)new CurrentItemStackComponent(testItemStack));
                    itemStack.method_57379(EPDataComponentTypes.PROGRESS, (Object)0);
                    if (energyProduction / 100L <= MAX_EXTRACT) {
                        itemStack.method_57379(EPDataComponentTypes.MAX_PROGRESS, (Object)100);
                    } else {
                        itemStack.method_57379(EPDataComponentTypes.MAX_PROGRESS, (Object)((int)Math.ceil((double)energyProduction / (double)MAX_EXTRACT)));
                    }
                    class_1799 newItemStack = testItemStack.method_7972();
                    newItemStack.method_7934(1);
                    inventory.method_5447(i, newItemStack);
                    if (testItemStack.getRecipeRemainder().method_7960()) return;
                    class_1799 craftingRemainingItem = testItemStack.getRecipeRemainder();
                    if (!inventory.method_7394(craftingRemainingItem)) return;
                    player.method_7328(craftingRemainingItem, false);
                    return;
                }
            }
            ++i;
        }
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (level.method_8608()) {
            return class_1271.method_22427((Object)itemStack);
        }
        itemStack.method_57379(EPDataComponentTypes.ACTIVE, (Object)(!this.isActive(itemStack) ? 1 : 0));
        return class_1271.method_22427((Object)itemStack);
    }

    private void resetProgress(class_1799 itemStack) {
        itemStack.method_57381(EPDataComponentTypes.ENERGY_PRODUCTION_LEFT);
        itemStack.method_57381(EPDataComponentTypes.PROGRESS);
        itemStack.method_57381(EPDataComponentTypes.MAX_PROGRESS);
        itemStack.method_57381(EPDataComponentTypes.CURRENT_ITEM);
        itemStack.method_57381(EPDataComponentTypes.WORKING);
    }

    private int getProgress(class_1799 itemStack) {
        return (Integer)itemStack.method_57825(EPDataComponentTypes.PROGRESS, (Object)-1);
    }

    private int getMaxProgress(class_1799 itemStack) {
        return (Integer)itemStack.method_57825(EPDataComponentTypes.MAX_PROGRESS, (Object)-1);
    }

    private class_1799 getCurrentBurningItem(class_1799 itemStack) {
        CurrentItemStackComponent currentItem = (CurrentItemStackComponent)itemStack.method_57824(EPDataComponentTypes.CURRENT_ITEM);
        return currentItem == null ? null : currentItem.getCurrentItem();
    }

    private long getEnergyProductionLeft(class_1799 itemStack) {
        return (Long)itemStack.method_57825(EPDataComponentTypes.ENERGY_PRODUCTION_LEFT, (Object)-1L);
    }

    @Override
    public boolean isActive(class_1799 itemStack) {
        return (Boolean)itemStack.method_57825(EPDataComponentTypes.ACTIVE, (Object)false);
    }

    @Override
    public boolean isWorking(class_1799 itemStack) {
        return (Boolean)itemStack.method_57825(EPDataComponentTypes.WORKING, (Object)false);
    }
}

